/* $Header: /home/cvs/bp/oofem/oofemlib/src/integrationrule.C,v 1.7.4.1 2004/04/05 15:19:43 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/


// file integrationRule.C

#include "integrationrule.h"
#include "material.h"
#include "crosssection.h"
#include "gausspnt.h"

// initialize class member 

IntegrationRule::IntegrationRule (int n, Domain* domain, int startIndx, int endIndx)
: FEMComponent (n,NULL)
{
  domain = domain;
  
  numberOfIntegrationPoints = 0;
  firstLocalStrainIndx = startIndx;
  lastLocalStrainIndx  = endIndx;
}


IntegrationRule::~IntegrationRule ()
{
 int i;

 if (gaussPointArray) {
  for (i=0 ; i<numberOfIntegrationPoints ; i++)
   delete gaussPointArray[i] ;
  delete gaussPointArray ;}
}

GaussPoint* 
IntegrationRule :: getIntegrationPoint (int i)
{
#  ifdef DEBUG
 if ((i < 0) || (i >= numberOfIntegrationPoints)) {
   _error2 ("IntegrationRule::getIntegrationPoint - request out of bounds (%d)",i);
 }
#  endif
 return gaussPointArray[i];
}

void
IntegrationRule :: printOutputAt (FILE* file, TimeStep* stepN)
// Performs end-of-step operations.
{
 int i;

    for (i=0 ; i < numberOfIntegrationPoints ; i++)
    gaussPointArray[i] -> printOutputAt(file, stepN);
}

void
IntegrationRule :: updateYourself (TimeStep* tStep)
{
 // Updates the receiver at end of step.
 int i;

 for (i=0 ; i < numberOfIntegrationPoints ; i++)
  gaussPointArray[i] -> updateYourself(tStep) ;
}

 
void
IntegrationRule :: initForNewStep ()
{
 // initializes receiver to new time step or can be used
 // if current time step must be restarted
 // 
 // call material->initGpForNewStep() for all GPs.
 //

 int i;
 
 for (i=0 ; i < numberOfIntegrationPoints ; i++)
  gaussPointArray[i]->giveMaterial()->initGpForNewStep(gaussPointArray[i]);
}


contextIOResultType
IntegrationRule :: saveContext (FILE* stream, void *obj)
{
 //
 // saves full  context (saves state variables, that completely describe
 // current state)
 //

  contextIOResultType iores;
 int         i ;
  GaussPoint* gp ;

  if (stream == NULL) _error ("saveContex : can't write into NULL stream");
  
  for (i=0 ; i < numberOfIntegrationPoints ; i++) {
    gp = gaussPointArray[i] ;
    if ((iores = gp->giveCrossSection()->saveContext(stream,gp)) != CIO_OK) THROW_CIOERR(iores);
  }
 
  return CIO_OK;
}

contextIOResultType
IntegrationRule :: restoreContext (FILE* stream, void *obj)
{
 //
 // restores full element context (saves state variables, that completely describe
 // current state)
 //
 
  contextIOResultType iores;
 int         i ;
  GaussPoint* gp ;
 
  if (stream == NULL) _error ("restoreContex : can't write into NULL stream");
  
  for (i=0 ; i < numberOfIntegrationPoints ; i++) {
    gp = gaussPointArray[i] ;
    if ((iores = gp -> giveCrossSection()->restoreContext(stream,gp)) != CIO_OK) THROW_CIOERR(iores);
  }
 
  return CIO_OK;
}


int 
IntegrationRule :: setUpIntegrationPoints (integrationDomain mode, int nPoints, Element* elem,
               MaterialMode matMode)
{
  switch (mode) {
  case _Line:
    return  (numberOfIntegrationPoints = this->SetUpPointsOnLine (nPoints , elem, matMode, &gaussPointArray)) ;

  case _Triangle:
    return  (numberOfIntegrationPoints = this->SetUpPointsOnTriagle (nPoints , elem, matMode, &gaussPointArray)) ;

  case _Square:
    return  (numberOfIntegrationPoints = this->SetUpPointsOnSquare  (nPoints , elem, matMode, &gaussPointArray)) ;

  case _Cube:
    return  (numberOfIntegrationPoints = this->SetUpPointsOnCube    (nPoints , elem, matMode, &gaussPointArray)) ;

  case _Tetrahedra:
    return  (numberOfIntegrationPoints = this->SetUpPointsOnTetrahedra (nPoints , elem, matMode, &gaussPointArray)) ;

  default:
    _error ("IntegrationRule::setUpIntegrationPoints - unknown mode");
  }
  return 0;
}
