/* $Header: /home/cvs/bp/oofem/oofemlib/src/mathfem.h,v 1.13 2003/05/19 13:03:57 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

/*
// This file contains some functions used in the finite element
// application.
// ref : Lippman p 104
// ! friend functions may not be declared inline (C++\Views p 17)
*/
#ifndef __MAKEDEPEND
#include <math.h>
#endif
#include "compiler.h"

#ifndef HAVE_M_PI
#define M_PI 3.1415926535897932384626433832795029L /* pi */
#endif
#ifndef HAVE_M_LN2
#define M_LN2 0.6931471805599453094172321214581766L  /* log_e 2 */
#endif

//#ifdef LINUX_PLATFORM
/**
 Macro returning the value of _VAL1 raised to the power of _VAL2.
*/
#define __OOFEM_POW(_VAL1,_VAL2) (pow((_VAL1),(_VAL2)))
//#define __OOFEM_POW(_VAL1,_VAL2) (exp((_VAL2)*log(_VAL1)))
//#endif
//#ifndef LINUX_PLATFORM
//#define __OOFEM_POW(_VAL1,_VAL2) pow (_VAL1,_VAL2)
//#endif

#ifndef HAVE_NEAREST
#define nearest(x) floor ((x)+0.5)
#endif

/// Returns smaller value from two given decimals
inline  int min (int i,int j)
   { return (i<=j ? i : j) ; } 

/// Returns smaller value from two given floats
inline  double min (double i, double j)
{ return (i<=j ? i : j) ; } 

/// Returns bigger value form two given decimals
inline  int max (int i,int j)
   { return (i>=j ? i : j) ; }

/// Returns bigger value form two given floats
inline  double max (double i,double j)
   { return (i>=j ? i : j) ; }

/// Returns the signum of given value (if value is < 0 returns -1, otherwise returns 1)
inline double sgn (double i)
   { return (i< 0. ? -1.: 1.); }

/// Returns the postive part of given float
inline double macbra (double x) {return (x+fabs(x))/2.0;}

/**
 Solves cubic equation for real roots.
 @param a,b,c,d - coefficients of equation in form: \f$ax^3 + bx^2 + cx + d = 0\f$
 @param r1,r2,r3 - roots (only first num roots is valid)
 @param num      - number of roots resolved
*/
void cubic (double a, double b, double c, double d, double*r1, double *r2, double *r3, int *num);

/**
 Solves cubic equation for real roots, assumung that if cubic polynomial given then only possibility 
 is that only three real roots exists. But also accepts cubic coefficient degenerated to
 quadratic or linear equation.
 This is used by algorithms for computing principal strain/stresses to 
 overcome rounding errors.
 @param a,b,c,d - coefficients of equation in form: \f$ax^3 + bx^2 + cx + d = 0\f$
 @param r1,r2,r3 - roots (only first num roots is valid)
 @param num      - number of roots resolved
*/
void cubic3r (double a, double b, double c, double d, double*r1, double *r2, double *r3, int *num);

/**
 Returns iperm of val, in specific rank
*/
int iperm (int val, int rank);




