/* $Header: /home/cvs/bp/oofem/oofemlib/src/usrdefsub.h,v 1.14 2003/05/19 13:03:58 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

//   ********************************************
//   file: usrdefsub.h - User defined Subroutines
//   ********************************************
 

#ifndef usrdefsub_h
#define usrdefsub_h

#include "domain.h"
#include "element.h"
#include "crosssection.h"
#include "engngm.h"
#include "load.h"
#include "loadtime.h"
#include "material.h"
#include "sparselinsystemnm.h"
//#include "nonlocalbarrier.h"
//

/**
 Creates new instance of element corresponding to given element keyword.
 @param name element keyword string determining the type of new instance
 @param num  element number
 @param d    domain assigned to new element
 @return newly allocated object of requested type, null if keyword not suppported
*/
Element* CreateUsrDefElementOfType (char*, int, Domain*);
/**
 Creates new instance of user defined dof manager corresponding to given keyword.
 @param name keyword string determining the type of new instance
 @param num  component number
 @param d    domain assigned to new object
 @return newly allocated object of requested type, null if keyword not suppported
*/
DofManager* CreateUsrDefDofManagerOfType (char*, int, Domain*);
/**
 Creates new instance of user defined cross section model corresponding to given keyword.
 @param name keyword string determining the type of new instance
 @param num  component number
 @param d    domain assigned to new object
 @return newly allocated object of requested type, null if keyword not suppported
*/
CrossSection* CreateUsrDefCrossSectionOfType(char*, int, Domain*);
/**
 Creates new instance of user defined engng model corresponding to given keyword.
 @param name keyword string determining the type of new instance
 @param number  component number
 @return newly allocated object of requested type, null if keyword not suppported
*/
EngngModel* CreateUsrDefEngngModelOfType(char*, int, EngngModel* _master = NULL);
/**
 Creates new instance of user defined load  corresponding to given keyword.
 @param name keyword string determining the type of new instance
 @param num  component number
 @param d    domain assigned to new object
 @return newly allocated object of requested type, null if keyword not suppported
*/
Load* CreateUsrDefLoadOfType(char*, int, Domain*);
/**
 Creates new instance of user defined load time function corresponding to given keyword.
 @param name keyword string determining the type of new instance
 @param num  component number
 @param d    domain assigned to new object
 @return newly allocated object of requested type, null if keyword not suppported
*/
LoadTimeFunction* CreateUsrDefLoadTimeFunctionOfType(char*, int, Domain*);
/**
 Creates new instance of user defined material model corresponding to given keyword.
 @param name keyword string determining the type of new instance
 @param num  component number
 @param d    domain assigned to new object
 @return newly allocated object of requested type, null if keyword not suppported
*/
Material* CreateUsrDefMaterialOfType(char*, int, Domain*);

/**
 Creates new Empty Instance of Sparse matrix of given type (the constructor with no parameters is called).
 @param type determines sparseMtrx type
 @return newly allocated object of requested type, null if keyword not suppported
*/
SparseMtrx* CreateUsrDefSparseMtrx(SparseMtrxType type);
/**
 Creates new Instance of Linear Sparse Solver of given type (the constructor with no parameters is called).
 @param st solver type
 @param i cpomponent number
 @param d domain 
 @param m emodel
 @return newly allocated object of requested type, null if keyword not suppported
*/
SparseLinearSystemNM* CreateUsrDefSparseLinSolver(LinSystSolverType st, int i, Domain* d, EngngModel* m);

//

/**
 Creates new Instance of Export Module of given name.
 @param name determines Export module type
 @param emodel engn model associated to new export module
 @return newly allocated object of requested type, null if keyword not suppported
*/
ExportModule* CreateUsrDefExportModuleOfType (char* name, EngngModel* emodel);


/**
 Creates new Instance of Nonlocal Barrier class corresponding to given name.
 @param name determines Nonlocal Barrier type
 @param num  component number
 @param d    domain assigned to new object
 @return newly allocated object of requested type, null if keyword not suppported
*/
NonlocalBarrier* CreateUsrDefNonlocalBarrierOfType (char* name, int num, Domain*d);

#endif
