/* $Header: /home/cvs/bp/oofem/sm/src/axisymm3d.h,v 1.5.4.1 2004/04/05 15:19:46 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

//   ********************************************************************
//   *** CLASS AXISYMMETRIC CONTINUUM
//   ********************************************************************
 
#ifndef axisymm3d_h

#include "nlstructuralelement.h"
#include "fei2dtrlin.h"
#include "zznodalrecoverymodel.h"
#include "nodalaveragingrecoverymodel.h"
#include "sprnodalrecoverymodel.h"



class Axisymm3d : public NLStructuralElement, public ZZNodalRecoveryModelInterface, 
public NodalAveragingRecoveryModelInterface, public SPRNodalRecoveryModelInterface
{
/*
   This class implements an triangular three-node finite element 
   for axisymmetric continuum 
   Each node has 2 degrees of freedom.
 
 DESCRIPTION :
 
 TASKS :
 
   - calculating its B,D,N matrices and dV.
*/

protected:
  static FEI2dTrLin interpolation;

  int numberOfGaussPoints, numberOfFiAndShGaussPoints;
  double area;
  
public:
  Axisymm3d (int,Domain*) ;                          // constructor
  ~Axisymm3d();                                      // destructor

 virtual int        computeNumberOfDofs () {return 6;}
 virtual void       giveNodeDofIDMask  (int inode, IntArray&) const;

  // characteristic length in gp (for some material models)
  double        giveCharacteristicLenght (GaussPoint*, const FloatArray&) ;
 double             computeVolumeAround (GaussPoint*);
 /**
  Computes the global coordinates from given element's local coordinates.
  Required by nonlocal material models.
  @returns nonzero if successful
  */
 int     computeGlobalCoordinates (FloatArray& answer, const FloatArray& lcoords) ;
 void    computeStrainVector (FloatArray& answer, GaussPoint*,TimeStep*);

  /** Interface requesting service */
  Interface* giveInterface (InterfaceType);

#ifdef __OOFEG
  void          drawRawGeometry (oofegGraphicContext&);
  void          drawDeformedGeometry(oofegGraphicContext&, UnknownType type);
 virtual void  drawScalar   (oofegGraphicContext& context);
  // void          drawInternalState (oofegGraphicContext&);
 
#endif

/**
 @name The element interface required by ZZNodalRecoveryModel
*/
//@{
 /**
  Returns the size of DofManger record required to hold recovered values for given mode.
  @param type determines the type of internal variable to be recovered
  @return size of DofManger record required to hold recovered values
  */
  int ZZNodalRecoveryMI_giveDofManRecordSize(InternalStateType type);
 /**
  Returns the corresponding element to interface 
  */
  Element* ZZNodalRecoveryMI_giveElement () {return this;}
  /**
  Evaluates N matrix (interpolation estimated stress matrix).
  */
  void ZZNodalRecoveryMI_ComputeEstimatedInterpolationMtrx (FloatMatrix& answer, GaussPoint* aGaussPoint, 
                                    InternalStateType type);
//@}
/**
 @name The element interface required by NodalAveragingRecoveryModel
*/
//@{
 /**
  Computes the element value in given node.
  @param answer contains the result
  @param node element node number
  @param type determines the type of internal variable to be recovered
  @param tStep time step
  */
  void NodalAveragingRecoveryMI_computeNodalValue (FloatArray& answer, int node,
                          InternalStateType type, TimeStep* tStep);
 /**
  Computes the element value in given side.
  @param answer contains the result
  @param node element side number
  @param type determines the type of internal variable to be recovered
  @param tStep time step
  */
  void NodalAveragingRecoveryMI_computeSideValue (FloatArray& answer, int side,
                          InternalStateType type, TimeStep* tStep);
 /**
  Returns the size of DofManger record required to hold recovered values for given mode.
  @param type determines the type of internal variable to be recovered
  @return size of DofManger record required to hold recovered values
  */
 virtual int NodalAveragingRecoveryMI_giveDofManRecordSize(InternalStateType type) 
  {return ZZNodalRecoveryMI_giveDofManRecordSize(type);}
//@}
/**
 @name The element interface required by SPRNodalRecoveryModelInterface
*/
//@{
   void SPRNodalRecoveryMI_giveSPRAssemblyPoints (IntArray& pap);
   void SPRNodalRecoveryMI_giveDofMansDeterminedByPatch (IntArray& answer, int pap);
   int SPRNodalRecoveryMI_giveDofManRecordSize(InternalStateType type)  
   {return ZZNodalRecoveryMI_giveDofManRecordSize(type);}
  int SPRNodalRecoveryMI_giveNumberOfIP ();
  void SPRNodalRecoveryMI_computeIPGlobalCoordinates (FloatArray& coords, GaussPoint* gp);
  SPRPatchType SPRNodalRecoveryMI_givePatchType();
//@}


// 
// definition & identification
//
 MaterialMode          giveMaterialMode() {return   _3dMat;}
 const char*  giveClassName () const { return "Axisymm3d" ;}
 classType     giveClassID () const { return Axisymm3dClass; } 
 virtual int testElementExtension (ElementExtension ext) {return ((ext==Element_EdgeLoadSupport)?1:0);}
 IRResultType initializeFrom (InputRecord* ir);
 
protected:
  void               computeBmatrixAt (GaussPoint*, FloatMatrix&, int=1,int=ALL_STRAINS); 
  void               computeNmatrixAt (GaussPoint*, FloatMatrix&) ; 
  void               computeGaussPoints ();
  integrationDomain  giveIntegrationDomain () {return _Triangle;}
  
  // edge load support
  void  computeEgdeNMatrixAt (FloatMatrix& answer, GaussPoint*) ;
  void  giveEdgeDofMapping (IntArray& answer, int) const;
  double        computeEdgeVolumeAround (GaussPoint*, int);
  void          computeEdgeIpGlobalCoords (FloatArray& answer, GaussPoint* gp, int iEdge) ;
  int   computeLoadLEToLRotationMatrix (FloatMatrix&, int, GaussPoint*) ;
} ;

#define axisymm3d_h
#endif
