/* $Header: /home/cvs/bp/oofem/sm/src/eigenvaluedynamic.C,v 1.5.4.1 2004/04/05 15:19:46 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

//
// file eigenvaluedynamic.cc
//

#include "eigenvaluedynamic.h"
#include "nummet.h"
#include "subspaceit.h"
#include "timestep.h"
#include "element.h"
#include "node.h"
#include "elementside.h"
#ifndef __MAKEDEPEND
#include <stdio.h>
#include <math.h>
#endif
#include "flotmtrx.h"
#include "cltypes.h"
#include "verbose.h"
#include "flotarry.h"
#include "skyline.h"

#ifdef __OOFEG
#include "oofeggraphiccontext.h"
#endif

NumericalMethod*   EigenValueDynamic :: giveNumericalMethod (TimeStep*)
// only one is awailable now 
//     - SubspaceIteration

{
  if (nMethod) return nMethod ;
  SparseGeneralEigenValueSystemNM* nm;
  nm = (SparseGeneralEigenValueSystemNM*) new SubspaceIteration (1,this->giveDomain(1),this);
  nMethod = nm;
  return nm;
}

IRResultType
EigenValueDynamic :: initializeFrom (InputRecord* ir)
{
 const char *__keyword, *__proc = "initializeFrom"; // Required by IR_GIVE_FIELD macro
 IRResultType result;                               // Required by IR_GIVE_FIELD macro
 //EngngModel::instanciateFrom (ir);

 IR_GIVE_FIELD (ir, numberOfRequiredEigenValues, "nroot"); // Macro

  // numberOfSteps set artifficially to numberOfRequiredEigenValues
  // in order to allow
  // use restoreContext function for different eigenValues
  // numberOfSteps = numberOfRequiredEigenValues;
 numberOfSteps = 1;

 IR_GIVE_FIELD (ir, rtolv, "rtolv"); // Macro
  if(rtolv < 1.e-12) rtolv =  1.e-12 ;
  if(rtolv > 0.01 ) rtolv =  0.01  ;

  return IRRT_OK;
}





double  EigenValueDynamic ::  giveUnknownComponent (UnknownType chc, ValueModeType mode,
                  TimeStep* tStep, Domain* d, Dof* dof)
// returns unknown quantity like displaacement, eigen value.
// This function translates this request to numerical method language
{
 int eq = dof->giveEquationNumber();
 if (eq == 0) _error ("giveUnknownComponent: invalid equation number");

 if (chc == EigenValue) {
  return eigVal.at(eq);
 } else if (!((chc == EigenVector)||(chc == DisplacementVector))) {
  _error ("giveUnknownComponent: Unknown is of undefined CharType for this problem");
  return 0.;
 }
 
  switch (mode)
    {
    case VM_Total:  // EigenVector
      return eigVec.at(eq, (int)tStep->giveTime());
    default:
      _error ("giveUnknownComponent: Unknown is of undefined type for this problem");
    }
  return 0.;
}


TimeStep*  EigenValueDynamic :: giveNextStep ()
{
  int istep = giveNumberOfFirstStep();
  StateCounterType counter = 1;

  delete previousStep;
  if (currentStep != NULL) {
    istep =  currentStep->giveNumber() + 1   ;
  counter = currentStep->giveSolutionStateCounter() + 1;
 }
  previousStep = currentStep;
  currentStep = new TimeStep (istep,this,1,(double)istep,0.,counter);
  // time and dt variables are set eq to 0 for staics - has no meaning

  return currentStep;
}

void   EigenValueDynamic :: solveYourselfAt (TimeStep* tStep) {
//
// creates system of governing eq's and solves them at given time step
//
// first assemble problem at current time step
/*  int nelem = domain -> giveNumberOfElements ();
  int nnode = domain -> giveNumberOfNodes();
  IntArray* loc ;
  Element* element;
  Node* node ;
*/
 int i;
#ifdef VERBOSE
 OOFEM_LOG_INFO("Assembling stiffness and mass matrices\n");
#endif
  
  if (tStep->giveNumber() == 1) {
    //
    // first step  assemble stiffness Matrix
    //
  /*
    IntArray* mht = this -> GiveBanWidthVector ();
    stiffnessMatrix = new Skyline ();
    massMatrix = new Skyline ();
    stiffnessMatrix ->  checkSizeTowardsBanWidth (mht) ;
    massMatrix ->  checkSizeTowardsBanWidth (mht) ;
    delete mht;
  */
  stiffnessMatrix = new Skyline ();
  stiffnessMatrix -> buildInternalStructure (this,1);
  massMatrix = stiffnessMatrix->GiveCopy();
  
    this -> assemble (stiffnessMatrix, tStep, StiffnessMatrix, this->giveDomain(1));
    this -> assemble (massMatrix, tStep, MassMatrix, this->giveDomain(1))          ;
//
// create resulting objects eigVec and eigVal
// 
    eigVec.resize (stiffnessMatrix -> giveNumberOfColumns(), numberOfRequiredEigenValues); eigVec.zero();
    eigVal.resize (numberOfRequiredEigenValues); eigVal.zero();
    /* for (int i = 1; i <= nelem ; i++ ) {
      element = domain -> giveElement(i);
      loc = element -> giveLocationArray ();
      charMtrx = element -> GiveCharacteristicMatrix ( StiffnessMatrix, tStep );
      stiffnessMatrix ->  assemble (charMtrx, loc) ;
  delete charMtrx;
      charMtrx = element -> GiveCharacteristicMatrix ( MassMatrix, tStep );
      massMatrix ->  assemble (charMtrx, loc) ;
  delete charMtrx;
    }*/

  }
  //
  // set-up numerical model
  //
 this->giveNumericalMethod(tStep);
/*
  nMethod -> setSparseMtrxAsComponent ( AEigvMtrx , stiffnessMatrix) ; 
  nMethod -> setSparseMtrxAsComponent ( BEigvMtrx , massMatrix) ; 
  nMethod -> setDoubleAsComponent ( NumberOfEigenValues , numberOfRequiredEigenValues) ;
  nMethod -> setDoubleAsComponent ( PrescribedTolerancy , rtolv) ;
  nMethod -> setFloatMatrixAsComponent ( EigenVectors,  eigVec);
  nMethod -> setFloatArrayAsComponent ( EigenValues, eigVal);
*/
  //  
  // call numerical model to solve arised problem
  //
#ifdef VERBOSE
 OOFEM_LOG_INFO("Solving ...\n");
#endif

 //nMethod -> solveYourselfAt(tStep);
 nMethod -> solve(stiffnessMatrix,massMatrix,&eigVal,&eigVec,rtolv,numberOfRequiredEigenValues);
 // compute eigen frequencies
 for (i = 1; i<= numberOfRequiredEigenValues; i++) 
  eigVal.at(i) = sqrt(eigVal.at(i));
    
  delete  stiffnessMatrix;
  delete  massMatrix ;
  //delete  eigVec; 
  //delete  eigVal;
  stiffnessMatrix = massMatrix = NULL;
  //eigVec = NULL; eigVal = NULL;

 // update nodes, elements, etc.
 this->updateYourself(this->giveCurrentStep());
 
}

void  EigenValueDynamic :: updateYourself (TimeStep *stepN) 
{
}



void   EigenValueDynamic :: terminate (TimeStep* stepN)
{
 Domain* domain = this->giveDomain(1);
  FILE* outputStream = this->giveOutputStream();
   int i,j ;

 // print loadcase header
 fprintf (outputStream,"\nOutput for time % .3e \n\n",1.0);
  // print eigen values on output
  fprintf (outputStream,"\n\nEigen Values are:\n-----------------\n");
  //this->giveNumericalMethod(stepN)->giveFloatArrayComponent(EigenValues,&eigv);

 for (i = 1; i<= numberOfRequiredEigenValues; i++) {
    fprintf (outputStream,"%15.8e ",eigVal.at(i));
    if ((i%5) == 0) fprintf(outputStream,"\n");
  }
  fprintf(outputStream,"\n\n");
  
  int nnodes = domain->giveNumberOfDofManagers ();

  for (i = 1; i<=  numberOfRequiredEigenValues; i++) {
  fprintf (outputStream,"\nOutput for eigen value no.  % .3e \n",(double) i);
    fprintf(outputStream,
      "Printing eigen vector no. %d, corresponding eigen value is %15.8e\n\n",
      i,eigVal.at(i));
  stepN->setTime ((double) i);  // we use time as intrinsic eigen value index
  
  if (this->requiresUnknowsDictionaryUpdate()) {
   for( j=1;j<=nnodes;j++) 
    this->updateDofUnknownsDictionary (domain -> giveDofManager(j),stepN) ;
  }
  
  
    for( j=1;j<=nnodes;j++) {
   domain->giveDofManager(j) -> updateYourself(stepN) ;
      domain->giveDofManager(j)->printOutputAt(outputStream, stepN);
  }
 }
 
#  ifdef VERBOSE
  VERBOSE_PRINT0("Updated nodes & sides ",nnodes)
#  endif

/*  int nelem = domain->giveNumberOfElements ();
  for (j=1 ; j<=nelem ; j++) {
    elem = domain -> giveElement(j) ;
  elem -> updateYourself(stepN) ;}

#  ifdef VERBOSE
  VERBOSE_PRINT0("Updated Elements ",nelem)
#  endif

 REMARK:
  I dont update elements - because it invokes updating strain and streses
  in GaussPoints - it not necesarry now - so I omit this part of code
*/

 this->saveStepContext(stepN);
}


contextIOResultType EigenValueDynamic :: saveContext (FILE* stream, void *obj)
// 
// saves state variable - displacement vector
//
{
 int closeFlag = 0;
 contextIOResultType iores;

  if (stream==NULL) {
  if (!this->giveContextFile(&stream, this->giveCurrentStep()->giveNumber(), 
                this->giveCurrentStep()->giveVersion(), contextMode_write)) 
   THROW_CIOERR(CIO_IOERR); // override 
  closeFlag = 1;
 }

  if ((iores = EngngModel :: saveContext (stream)) != CIO_OK) THROW_CIOERR(iores);
  if ((iores = eigVal.storeYourself(stream)) != CIO_OK) THROW_CIOERR(iores);
  if ((eigVec.storeYourself(stream)) != CIO_OK) THROW_CIOERR(iores);

  if (closeFlag) fclose (stream); // ensure consistent records
  return CIO_OK;
}



contextIOResultType EigenValueDynamic :: restoreContext (FILE* stream, void *obj)
// 
// restore state variable - displacement vector
//
{
 int closeFlag = 0;
  int activeVector = this->resolveCorrespondingEigenStepNumber (obj);
 int istep = 1, iversion = 1;
 contextIOResultType iores;

  if (restoreFlag == 0) { // not restored before

   if (stream == NULL) {
    if (!this->giveContextFile(&stream, istep, iversion, contextMode_read)) 
     THROW_CIOERR(CIO_IOERR); // override 
    closeFlag = 1;
   }
      // save element context
  
      if ((iores = EngngModel :: restoreContext (stream, (void*) &istep)) != CIO_OK) THROW_CIOERR(iores);
      if ((iores = eigVal.restoreYourself(stream)) != CIO_OK) THROW_CIOERR(iores);
      if ((iores = eigVec.restoreYourself(stream)) != CIO_OK) THROW_CIOERR(iores);
   if (closeFlag) fclose (stream); // ensure consistent records
   
    } 

  if (activeVector > numberOfRequiredEigenValues) activeVector = numberOfRequiredEigenValues ;
 OOFEM_LOG_INFO("Restoring - corresponding index is %d, EigenValue is %f\n", activeVector,eigVal.at(activeVector));
 this->giveCurrentStep()->setTime ((double) activeVector);
 this->restoreFlag = 1;
 
  return CIO_OK;
}


int EigenValueDynamic :: resolveCorrespondingEigenStepNumber (void* obj)
{
// 
// returns corresponding eigen step number
//
 if (obj == NULL) return 1;
 int *istep = (int*) obj;

 if (*istep > numberOfRequiredEigenValues) {
  return numberOfRequiredEigenValues;
 }
 if (*istep <= 0) return 1;
 return *istep;
}


void 
EigenValueDynamic::printDofOutputAt (FILE* stream, Dof* iDof, TimeStep* atTime) 
{
 iDof->printSingleOutputAt(stream, atTime, 'd', DisplacementVector, VM_Total);
}
