/* $Header: /home/cvs/bp/oofem/sm/src/heavisideltf.C,v 1.3 2003/04/06 14:08:30 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

//   file HeavisideLTF.CC

#include "heavisideltf.h"
#ifndef __MAKEDEPEND
#include <math.h>
#endif

double  
HeavisideLTF :: at (double time)
   // Returns the value of the receiver at time 'time'. 'time' should be
   // one of the dates of the receiver (currently there is no interpola-
   // tion between two points).
{
  double relTime = time - this->origin;
  if (relTime <=0.) return 0.;
  return value;
}


IRResultType
HeavisideLTF :: initializeFrom (InputRecord* ir)
// 
// initializes according to input record
//
{
 const char *__keyword, *__proc = "initializeFrom"; // Required by IR_GIVE_FIELD macro
 IRResultType result;                               // Required by IR_GIVE_FIELD macro
 
  
 IR_GIVE_FIELD (ir, origin, "origin"); // Macro
 IR_GIVE_FIELD (ir, value, "value"); // Macro

  return IRRT_OK;
} 
