/* $Header: /home/cvs/bp/oofem/sm/src/qtrplstr.h,v 1.5.4.1 2004/04/05 15:19:47 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

//   **************************
//   *** CLASS PLANE STRAIN ***
//   **************************
 
#ifndef qtrplstr_h


#include "structuralelement.h"
#include "spatiallocalizer.h"
//#include "zznodalrecoverymodel.h"
#include "sprnodalrecoverymodel.h"
//
#include "mathfem.h"

class QTrPlaneStress2d : public StructuralElement, public SpatialLocalizerInterface,  
public SPRNodalRecoveryModelInterface// , public ZZNodalRecoveryModelInterface
//
{
/*
   This class implements an triangular three-node  plane-
   stress elasticity finite element. Each node has 2 degrees of freedom.

 DESCRIPTION :
 
 TASKS :
 
   - calculating its B,D,N matrices and dV.
*/

protected:
  int numberOfGaussPoints;
  
public:
  QTrPlaneStress2d (int,Domain*) ;       // constructor
  ~QTrPlaneStress2d ()  {}               // destructor
 
 // FloatMatrix*    ComputeConstitutiveMatrixAt (GaussPoint *) ;
 // FloatArray*     ComputeBodyLoadVectorAt (TimeStep*) ;

  virtual int            computeNumberOfDofs () {return 12;}
  virtual void           giveNodeDofIDMask  (int inode, IntArray& ) const;
 // characteristic length in gp (for some material models)
  double        giveCharacteristicLenght (GaussPoint* gp, const FloatArray& normalToCrackPlane) {
   return this -> giveLenghtInDir(normalToCrackPlane) / sqrt ((double) this->numberOfGaussPoints);}
 /**
  Computes the global coordinates from given element's local coordinates.
  Required by nonlocal material models. 
  @returns nonzero if successful
  */
 virtual int computeGlobalCoordinates (FloatArray& answer, const FloatArray& lcoords) ;
 /**
  Computes the element local coordinates from given global coordinates.
  @returns nonzero if successful (if point is inside element); zero otherwise
  */
 virtual int computeLocalCoordinates (FloatArray& answer, const FloatArray& gcoords);

  double             computeVolumeAround (GaussPoint*) ;

  /** Interface requesting service */
  Interface* giveInterface (InterfaceType);

  virtual int testElementExtension       (ElementExtension ext) {return 0;}
  //int    hasEdgeLoadSupport () {return 0;}

#ifdef __OOFEG
      void          drawRawGeometry (oofegGraphicContext&);
      void          drawDeformedGeometry(oofegGraphicContext&, UnknownType);
      virtual void  drawScalar   (oofegGraphicContext& context);
      virtual void  drawSpecial  (oofegGraphicContext&);
#endif
 // 
 // definition & identification
 //
 const char* giveClassName () const { return "QTrPlaneStress2d";}
 classType       giveClassID ()          const { return QTrPlaneStress2dClass;}
  IRResultType initializeFrom (InputRecord* ir);

/**
 @name The element interface required by SpatialLocalizerInterface
*/
//@{
 /// Returns reference to corresponding element 
 virtual Element* SpatialLocalizerI_giveElement(){return this;}
 /// Returns nonzero if given element contains given point
 virtual int SpatialLocalizerI_containsPoint (const FloatArray& coords);
 /// Returns distance of given point from element parametric center
 virtual double SpatialLocalizerI_giveDistanceFromParametricCenter (const FloatArray& coords);
//@}

/**
 @name The element interface required by ZZNodalRecoveryModel
 currently not used -> problems in lumping procedure 
*/
//@{
 /**
  Returns the size of DofManger record required to hold recovered values for given mode.
  @param type determines the type of internal variable to be recovered
  @return size of DofManger record required to hold recovered values
  */
  //int ZZNodalRecoveryMI_giveDofManRecordSize(InternalStateType type);
 /**
  Returns the corresponding element to interface 
  */
  //Element* ZZNodalRecoveryMI_giveElement () {return this;}
  /**
  Evaluates N matrix (interpolation estimated stress matrix).
  */
  //void ZZNodalRecoveryMI_ComputeEstimatedInterpolationMtrx (FloatMatrix& answer, GaussPoint* aGaussPoint, 
 //                             InternalStateType type);
//@}

/**
 @name The element interface required by SPRNodalRecoveryModelInterface
*/
//@{
   void SPRNodalRecoveryMI_giveSPRAssemblyPoints (IntArray& pap);
   void SPRNodalRecoveryMI_giveDofMansDeterminedByPatch (IntArray& answer, int pap);
   int SPRNodalRecoveryMI_giveDofManRecordSize(InternalStateType type);
  int SPRNodalRecoveryMI_giveNumberOfIP ();
  //void SPRNodalRecoveryMI_giveIPValue (FloatArray& answer, int ipNum, InternalStateType type);
  void SPRNodalRecoveryMI_computeIPGlobalCoordinates (FloatArray& coords, GaussPoint* gp);
  SPRPatchType SPRNodalRecoveryMI_givePatchType();
//@}


//




protected:
 void            computeBmatrixAt (GaussPoint*, FloatMatrix&, int = 1,int = ALL_STRAINS) ;
 void            computeNmatrixAt (GaussPoint*, FloatMatrix&) ;
  void               computeGaussPoints () ;
 integrationDomain  giveIntegrationDomain () {return _Triangle;}
  int           giveApproxOrder () {return 2;}
  int  giveNumberOfIPForMassMtrxIntegration () {return 4;}

 void            computeDerivativeKsi (FloatArray&,double, double);
 void            computeDerivativeEta (FloatArray&,double, double);
 void            computeJacobianMatrixAt (FloatMatrix&,GaussPoint*);

};

#define qtrplstr_h 
#endif
