/* $Header: /home/cvs/bp/oofem/sm/src/trplanestrain.h,v 1.8 2003/04/06 14:08:32 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2000   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/

//   **************************
//   *** CLASS PLANE STRAIN ***
//   **************************
 
#ifndef trplanstrain_h

#include "nlstructuralelement.h"
#include "zznodalrecoverymodel.h"
#include "nodalaveragingrecoverymodel.h"
#include "sprnodalrecoverymodel.h"
#include "spatiallocalizer.h"
//

class TrPlaneStrain : public StructuralElement, public ZZNodalRecoveryModelInterface, 
public NodalAveragingRecoveryModelInterface, public SPRNodalRecoveryModelInterface, 
public SpatialLocalizerInterface
//
{
/*
   This class implements an triangular three-node  plane-
   strain elasticity finite element. Each node has 2 degrees of freedom.
 DESCRIPTION :

 TASKS :

   - calculating its B,D,N matrices and dV.
*/

protected:
  double area;
  int numberOfGaussPoints;
  
public:
  TrPlaneStrain (int,Domain*) ;                          // constructor
  ~TrPlaneStrain ()  {}                                  // destructor
  
  virtual int            computeNumberOfDofs () {return 6;}
  virtual void           giveNodeDofIDMask  (int inode, IntArray& ) const;


 // characteristic length in gp (for some material models)
 double        giveCharacteristicLenght (GaussPoint*, const FloatArray&) ;

 /**
  Computes the global coordinates from given element's local coordinates.
  Required by nonlocal material models. 
  @returns nonzero if successful
  */
 virtual int computeGlobalCoordinates (FloatArray& answer, const FloatArray& lcoords) ;
 /**
  Computes the element local coordinates from given global coordinates.
  @returns nonzero if successful (if point is inside element); zero otherwise
  */
 virtual int computeLocalCoordinates (FloatArray& answer, const FloatArray& gcoords) ;

  virtual int testElementExtension       (ElementExtension ext) {return ((ext==Element_EdgeLoadSupport)?1:0);}
  double             computeVolumeAround (GaussPoint*) ;

   /** Interface requesting service */
  Interface* giveInterface (InterfaceType);
 
/**
 @name The element interface required by ZZNodalRecoveryModel
*/
//@{
 /**
  Returns the size of DofManger record required to hold recovered values for given mode.
  @param type determines the type of internal variable to be recovered
  @return size of DofManger record required to hold recovered values
  */
  int ZZNodalRecoveryMI_giveDofManRecordSize(InternalStateType type);
 /**
  Returns the corresponding element to interface 
  */
  Element* ZZNodalRecoveryMI_giveElement () {return this;}
  /**
  Evaluates N matrix (interpolation estimated stress matrix).
  */
  void ZZNodalRecoveryMI_ComputeEstimatedInterpolationMtrx (FloatMatrix& answer, GaussPoint* aGaussPoint, 
                                    InternalStateType type);
//@}
/**
 @name The element interface required by NodalAveragingRecoveryModel
*/
//@{
 /**
  Computes the element value in given node.
  @param answer contains the result
  @param node element node number
  @param type determines the type of internal variable to be recovered
  @param tStep time step
  */
  void NodalAveragingRecoveryMI_computeNodalValue (FloatArray& answer, int node,
                          InternalStateType type, TimeStep* tStep);
 /**
  Computes the element value in given side.
  @param answer contains the result
  @param node element side number
  @param type determines the type of internal variable to be recovered
  @param tStep time step
  */
  void NodalAveragingRecoveryMI_computeSideValue (FloatArray& answer, int side,
                          InternalStateType type, TimeStep* tStep);
 /**
  Returns the size of DofManger record required to hold recovered values for given mode.
  @param type determines the type of internal variable to be recovered
  @return size of DofManger record required to hold recovered values
  */
 virtual int NodalAveragingRecoveryMI_giveDofManRecordSize(InternalStateType type) 
  {return ZZNodalRecoveryMI_giveDofManRecordSize(type);}
//@}
/**
 @name The element interface required by SPRNodalRecoveryModelInterface
*/
//@{
   void SPRNodalRecoveryMI_giveSPRAssemblyPoints (IntArray& pap);
   void SPRNodalRecoveryMI_giveDofMansDeterminedByPatch (IntArray& answer, int pap);
   int SPRNodalRecoveryMI_giveDofManRecordSize(InternalStateType type)  
   {return ZZNodalRecoveryMI_giveDofManRecordSize(type);}
  int SPRNodalRecoveryMI_giveNumberOfIP ();
  //void SPRNodalRecoveryMI_giveIPValue (FloatArray& answer, int ipNum, InternalStateType type);
  void SPRNodalRecoveryMI_computeIPGlobalCoordinates (FloatArray& coords, GaussPoint* gp);
  SPRPatchType SPRNodalRecoveryMI_givePatchType();
//@}

//

/**
 @name The element interface required by SpatialLocalizerInterface
*/
//@{
 /// Returns reference to corresponding element 
 virtual Element* SpatialLocalizerI_giveElement(){return this;}
 /// Returns nonzero if given element contains given point
 virtual int SpatialLocalizerI_containsPoint (const FloatArray& coords);
 /// Returns distance of given point from element parametric center
 virtual double SpatialLocalizerI_giveDistanceFromParametricCenter (const FloatArray& coords);
//@}

//

#ifdef __OOFEG
      void          drawRawGeometry (oofegGraphicContext&);
      void          drawDeformedGeometry(oofegGraphicContext&, UnknownType);
      virtual void  drawScalar   (oofegGraphicContext& context);
      //void          drawInternalState (oofegGraphicContext&);
#endif
// 
// definition & identification
//
  const char* giveClassName () const { return "TrPlaneStrain" ;}
  classType            giveClassID () const { return TrPlaneStrainClass; } 
  IRResultType initializeFrom (InputRecord* ir);
 Element_Geometry_Type giveGeometryType() const {return EGT_triangle_1;}


protected:
  // edge load support
  void  computeEgdeNMatrixAt (FloatMatrix& answer, GaussPoint*) ;
  void  giveEdgeDofMapping (IntArray& answer, int) const;
  double        computeEdgeVolumeAround (GaussPoint*, int);
  void          computeEdgeIpGlobalCoords (FloatArray& answer, GaussPoint* gp, int iEdge) ;
  int   computeLoadLEToLRotationMatrix (FloatMatrix&, int, GaussPoint*) ;
  void          computeBmatrixAt (GaussPoint*, FloatMatrix&, int = 1,int = ALL_STRAINS);
//  void          computeNLBMatrixAt(FloatMatrix& answer, GaussPoint*, int);

  void               computeNmatrixAt (GaussPoint*, FloatMatrix& ) ;
  // give Transformation matrix from global coord. syst. to local coordinate system in nodes. 
  // i.e. r(n)=T r(g).
//  int                computeGtoNRotationMatrix (FloatMatrix&);
  void               computeGaussPoints () ;
 integrationDomain  giveIntegrationDomain () {return _Triangle;}
 
  virtual double     giveArea ();
  virtual FloatArray*        GivebCoeff ();
  virtual FloatArray*        GivecCoeff ();
  int           giveApproxOrder () {return 1;}
  /**
   Return desired number of integration points for consistent mass matrix 
   computation, if required.
 */
 int  giveNumberOfIPForMassMtrxIntegration () {return 1;}

} ;

#define trplanstrain_h 
#endif







