/* $Header: /home/cvs/bp/oofem/tm/src/stationarytransportproblem.C,v 1.1.4.1 2004/04/05 15:19:53 bp Exp $ */
/*

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2002   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/


#include "stationarytransportproblem.h"
#include "nummet.h"
#include "ldltfact.h"
#include "imlsolver.h"
#include "timestep.h"
#include "metastep.h"
#include "element.h"
#include "dofmanager.h"
#include "elementside.h"
#include "cltypes.h"
#include "verbose.h"
#include "conTable.h"
#include "transportelement.h"
#include "usrdefsub.h"
#ifndef __MAKEDEPEND
#include <stdio.h>
#endif

NumericalMethod* StationaryTransportProblem :: giveNumericalMethod (TimeStep* atTime)
// only one has reason for LinearStatic 
//     - SolutionOfLinearEquations

{
  if (nMethod) return nMethod ;
 
 SparseLinearSystemNM* nm;
 if (solverType == ST_Direct) {
  nm = (SparseLinearSystemNM*) new LDLTFactorization (1,this->giveDomain(1),this);
  nMethod = nm;
  return nm;
 } else {
  nm = (SparseLinearSystemNM*) new IMLSolver (1,this->giveDomain(1),this);
  nMethod = nm;
  return nm;
 }
}

IRResultType
StationaryTransportProblem :: initializeFrom (InputRecord* ir)
{
 const char *__keyword, *__proc = "initializeFrom"; // Required by IR_GIVE_FIELD macro
 IRResultType result;                               // Required by IR_GIVE_FIELD macro

 EngngModel::initializeFrom (ir);
 int val = 0;
 IR_GIVE_OPTIONAL_FIELD (ir, val, "lstype"); // Macro
 solverType = (LinSystSolverType) val;

 val = 0;
 IR_GIVE_OPTIONAL_FIELD (ir, val, "smtype"); // Macro
 sparseMtrxType = (SparseMtrxType) val;

 /* The following done in updateAttributes
   if (this->giveNumericalMethod (giveCurrentStep())) nMethod -> instanciateFrom (ir);
 */
 
 // read field export flag
 exportFieldFlag = 0;
 if (ir->hasField("exportfields")) {
  IntArray atomicFieldID;
  IR_GIVE_FIELD (ir, atomicFieldID, "atomicfields"); // Macro
  // export flux fields
  FieldManager* fm = this->giveContext()->giveFieldManager();
  for (int i=1; i<=atomicFieldID.giveSize(); i++) {
   fm->registerField (&FluxField, (FieldType) atomicFieldID.at(i));
  }
 }


 return IRRT_OK;
}
 


double StationaryTransportProblem ::  giveUnknownComponent (UnknownType chc, ValueModeType mode, 
                              TimeStep* tStep, Domain* d, Dof* dof)
// returns unknown quantity like displaacement, velocity of equation eq
// This function translates this request to numerical method language
{
 
 int eq = dof->giveEquationNumber();
 if (eq == 0) _error ("giveUnknownComponent: invalid equation number");
 
  if (chc == FluxVector) {// heat and mass concetration vector
  return FluxField.giveUnknownValue (dof, mode, tStep);
 } else _error ("giveUnknownComponent: Unknown is of undefined CharType for this problem");

 /*
   switch (mode)
   {
   case VM_Total:
   case VM_Incremental:
   if (solutionVector.isNotEmpty()) return solutionVector.at(eq);
   else return 0.;
   // return nMethod-> giveUnknownComponent (LinearEquationSolution, eq);
   
   default:
   _error ("giveUnknownComponent: Unknown is of undefined type for this problem");
   }
   return 0.;
   */
 return 0.;
}  


TimeStep* StationaryTransportProblem :: giveNextStep ()
{
  int istep = this->giveNumberOfFirstStep();
 //int mstep = 1;
  StateCounterType counter = 1;
 delete previousStep;

  if (currentStep != NULL) {
    istep =  currentStep->giveNumber() + 1   ;
  counter = currentStep->giveSolutionStateCounter() + 1;
 }
  previousStep = currentStep;
  currentStep = new TimeStep (istep,this, 1, (double) istep, 0., counter);
  // time and dt variables are set eq to 0 for staics - has no meaning
  return currentStep;
}


void  StationaryTransportProblem :: solveYourselfAt (TimeStep* tStep) {
//
// creates system of governing eq's and solves them at given time step
//
// first assemble problem at current time step
 FluxField.advanceSolution(tStep);

  if (tStep->giveNumber() == 1) {

#ifdef VERBOSE
    OOFEM_LOG_INFO("Assembling conductivity matrix\n");
#endif

  // alocate space for solution vector
  FloatArray* solutionVector;
  solutionVector = FluxField.giveSolutionVector(tStep);
  solutionVector->resize(this->giveNumberOfEquations()); solutionVector->zero();
  
  conductivityMatrix = ::CreateUsrDefSparseMtrx(sparseMtrxType); 
  if (conductivityMatrix==NULL) _error ("solveYourselfAt: sparse matrix creation failed");
  conductivityMatrix->buildInternalStructure (this, 1);
  
  this -> assemble (conductivityMatrix, tStep, ConductivityMatrix, this->giveDomain(1));
  this -> assemble (conductivityMatrix, tStep, LHSBCMatrix, this->giveDomain(1));
 
}
#ifdef VERBOSE
 OOFEM_LOG_INFO("Assembling rhs\n");
#endif

  // 
  // assembling the element part of load vector
  //
 rhsVector.resize (this->giveNumberOfEquations()); 
 rhsVector.zero();
 
  this->assembleVectorFromElements(rhsVector, tStep, ElementInternalSourceVector, VM_Total, this->giveDomain(1));
  this->assembleVectorFromElements(rhsVector, tStep, ElementBCTransportVector, VM_Total, this->giveDomain(1));
 this->assembleDirichletBcRhsVector (rhsVector, tStep, VM_Total, ConductivityMatrix, this->giveDomain(1));
  // 
  // assembling the nodal part of load vector
  //
  this->assembleVectorFromDofManagers(rhsVector, tStep, NodalLoadVector, VM_Total, this->giveDomain(1)) ;

  //
  // set-up numerical model
  //
 this->giveNumericalMethod(tStep);

  // 
  // call numerical model to solve arised problem
  //
#ifdef VERBOSE
 OOFEM_LOG_INFO("Solving ...\n");
#endif

  //nMethod -> solveYourselfAt(tStep);
 nMethod -> solve (conductivityMatrix, &rhsVector, FluxField.giveSolutionVector(tStep));
 // update solution state counter
 tStep->incrementStateCounter();   

 // update nodes, elements, etc.
 this->updateYourself(this->giveCurrentStep());
} 

void    
StationaryTransportProblem :: updateYourself (TimeStep* stepN) 
{
 //this->updateInternalState(stepN);
 EngngModel::updateYourself(stepN);
}


contextIOResultType 
StationaryTransportProblem :: saveContext (FILE* stream, void *obj)
// 
// saves state variable - displacement vector
//
{
 contextIOResultType iores;
 int closeFlag = 0;

 if (stream==NULL) {
  if (!this->giveContextFile(&stream, this->giveCurrentStep()->giveNumber(), 
                this->giveCurrentStep()->giveVersion(), contextMode_write)) 
   THROW_CIOERR(CIO_IOERR); // override 
  closeFlag = 1;
 }

  if ((iores = EngngModel :: saveContext (stream)) != CIO_OK) THROW_CIOERR(iores);
  if ((iores = FluxField.saveContext(stream)) != CIO_OK) THROW_CIOERR(iores);

 if (closeFlag) fclose (stream); // ensure consistent records
  return CIO_OK;
}



contextIOResultType 
StationaryTransportProblem :: restoreContext (FILE* stream, void *obj)
// 
// restore state variable - displacement vector
//
{
 contextIOResultType iores;
 int closeFlag = 0;
 int istep, iversion;

 this->resolveCorrespondingStepNumber (istep, iversion, obj);

 if (stream == NULL) {
  if (!this->giveContextFile(&stream, istep, iversion, contextMode_read))
   THROW_CIOERR(CIO_IOERR); // override 
  closeFlag = 1;
 }

 if ((iores = EngngModel :: restoreContext (stream, obj)) != CIO_OK) THROW_CIOERR(iores);
 if ((iores = FluxField.restoreContext(stream)) != CIO_OK) THROW_CIOERR(iores);

 
  if (closeFlag) fclose (stream); // ensure consistent records
 return CIO_OK;
}


int
StationaryTransportProblem::checkConsistency ()
{
// check internal consistency
// if success returns nonzero
 int i, nelem;
 Element* ePtr;
 TransportElement* sePtr;
 Domain* domain = this->giveDomain(1);

 nelem = domain->giveNumberOfElements();
 // check for proper element type

 for (i=1; i<= nelem; i++) {
  ePtr = domain->giveElement(i);
  sePtr = dynamic_cast<TransportElement*>(ePtr);
  if (sePtr == NULL) {
    _warning2 ("Element %d has no TransportElement base",i);
    return 0;
  }
 }

 EngngModel :: checkConsistency ();

 return 1;
}


void
StationaryTransportProblem::updateDomainLinks ()
{
 EngngModel::updateDomainLinks();
 this->giveNumericalMethod(giveCurrentStep())->setDomain (this->giveDomain(1));
}


void
StationaryTransportProblem::printDofOutputAt (FILE* stream, Dof* iDof, TimeStep* atTime) 
{
 iDof->printSingleOutputAt(stream, atTime, 'f', FluxVector, VM_Total);
}

void
StationaryTransportProblem :: assembleDirichletBcRhsVector (FloatArray& answer, TimeStep* tStep, 
                              ValueModeType mode, CharType lhsType,
                              Domain* d)
{
  int ielem ;
  IntArray loc ;
 Element *element ;
 FloatArray  rp, charVec;
 FloatMatrix s;

  int nelem = d -> giveNumberOfElements ();

 for (ielem = 1; ielem <= nelem ; ielem++ ) {
  element = d -> giveElement(ielem);
  
  element -> computeVectorOfPrescribed(mode,tStep, rp) ;
  if (rp.containsOnlyZeroes())
   continue;
  else {
   this->giveElementCharacteristicMatrix (s, ielem, lhsType, tStep, d);
   charVec.beProductOf (s, rp); charVec.negated() ;   
   
   element -> giveLocationArray (loc);
   answer.assemble (charVec, loc) ;
  }
 } // end element loop
}

