
clear;

lengthX = 48;
lengthY = 44;

x1 = 0;
y1 = 0;

numberNodesX = 60;
numberNodesY = 60;
numberNodes = numberNodesX*numberNodesY;
numberElements = (numberNodesX-1)*(numberNodesY-1);
incrementX = lengthX/(numberNodesY-1);
incrementY = lengthY/(numberNodesX-1);

	

fileName = strcat('CooksMemabrane',num2str(numberNodes));

s1 = fopen(strcat(fileName,'.txt'),  'w');

fprintf(s1,strcat(fileName,'.out'));
fprintf(s1,'\nSimulation of Nearly Incompressible Cooks Memabrane Problem Using Enhanced Assume Strain Element Q1E4 \n');
fprintf(s1,'LinearStatic nsteps 1 \n');
%fprintf(s1,'NonLinearStatic nsteps 2 renumber 1 nmodules 1 controllmode 1  rtolv 1.e-9 stiffMode 0 manrmsteps 1 maxiter 10 lstype 1 smtype 1 stype 1 lstol 1.e-9 lsiter 400 \n');
%fprintf(s1,'vtkxml tstep_all domain_all primvars 1 1 vars 1 1\n');
fprintf(s1,'domain PlaneStrain\n');
fprintf(s1,'OutputManager tstep_all dofman_all element_all\n');
fprintf(s1,'ndofman %4d nelem %4d ncrosssect 1 nmat 1 nbc 3 nic 0 nltf 2\n',numberNodes, numberElements);
nodeNumber = 0;
	
    for i=0:numberNodesY-1
	
        for j = 0:numberNodesX-1
            nodeNumber = nodeNumber +1;
			coords(1) = x1+j*incrementX;
			coords(2) = y1+i*incrementY + (lengthY - 28/(numberNodesY-1) *i)/lengthX*coords(1);
            if(j == 0)
                fprintf(s1, 'Node %3d coords 2  %6.6f %6.6f bc 2 1 1\n', nodeNumber, coords(1), coords(2));
            elseif(j == numberNodesX-1)
                if((i == 0) || (i ==numberNodesY-1))
                    fprintf(s1, 'Node %3d coords 2  %6.6f %6.6f  load 1 2 \n', nodeNumber, coords(1), coords(2));
                else
                    fprintf(s1, 'Node %3d coords 2  %6.6f %6.6f  load 1 3 \n', nodeNumber, coords(1), coords(2));
                end
            else
                fprintf(s1, 'Node %3d coords 2  %6.6f %6.6f \n', nodeNumber, coords(1), coords(2));
            end
        end
    end
	
	
	
	elemNumber = 0;
	
	
    for i = 0 : numberNodesY-2
        for j = 0 : numberNodesX-2
        elemNumber = elemNumber + 1;
		elemNodeNumbers(1) = i*numberNodesX + j +1;
		elemNodeNumbers(2) = 1 + i*numberNodesX + j+1;
		elemNodeNumbers(3) = 1 + (i+1)* numberNodesX + j+1;
		elemNodeNumbers(4) = (i+1)* numberNodesX + j+1;
       fprintf(s1, 'Quad1PlaneStrain4EAS %3d nodes 4  %3d %3d %3d %3d crossSect 1 mat 1\n', elemNumber, elemNodeNumbers(1), elemNodeNumbers(2),elemNodeNumbers(3),elemNodeNumbers(4));
        end
       
    end
    
    
fprintf(s1,'SimpleCS 1 thick 1\n');
fprintf(s1,'isole 1 d 1. E 240.565 n 0.4999 talpha 1.0\n');
fprintf(s1,'BoundaryCondition  1 loadTimeFunction 1 prescribedvalue 0.0\n');
%fprintf(s1,'NodalLoad  2 loadTimeFunction 2 components 2 0 %6.6f\n', 100);
%fprintf(s1,'NodalLoad  3 loadTimeFunction 2 components 2 0  %6.6f\n', 200);
fprintf(s1,'NodalLoad  2 loadTimeFunction 2 components 2 0 %6.6f\n', 3.125*incrementY);
fprintf(s1,'NodalLoad  3 loadTimeFunction 2 components 2 0  %6.6f\n', 6.25*incrementY);
fprintf(s1,'ConstantFunction 1 f(t) 1.\n');
fprintf(s1,'ConstantFunction 2 f(t) 1.\n');
%fprintf(s1,'PiecewiseLinFunction 2 npoints 2 t 2 0. 1000. f(t) 2 0. 1000.\n');   
%#%BEGIN_CHECK%
%#NODE   number   9   dof   2   unknown   d
%#%END_CHECK%

    
    
fclose(s1);