class API:
    """
    An abstract class representing an Application Interface (API).
    It defines the required functionality provided by individual applications.
    """
    def giveField(self, fieldID, tstep):
        """
        Returns the requested field at given time. Field is identified by fieldID.
        Returns an error code if not succesfull.
        """
    
    def updateField(self, field, tstep):
        """
        Updates the provided field values to given time.
        Returns an error code if not succesfull.
        """
    def registerField(self, field, tstep):
        """
        Registers the given (remote) field in application. 
        """
    

    def solve(self, tstep):
        """
        Proceeds the solution from actual state to given time.
        Returns an error code.
        """

    def giveCriticalTimeStep(self):
        """
        Returns the actual (related to current state) critical time step.
        """
    def giveAssemblyTime(self, tstep):
        """
        Returns the assembly time related to given time step.
        The registered fields (inputs) should in general correspond to this time.
        """
        
class APIError(Exception):
    def __init__(self, _msg):
        self.msg = _msg
    def __str__(self):
         return repr(self.msg)
