import oofemlib
from  mupif import mesh
from  mupif import field
from  mupif import vertex
from  mupif import cell
from  mupif.api import api

class OofemUnstructuredMesh(mesh.UnstructuredMesh):
    """
    This class implements mupif.UnstructuredMesh interface to oofem.Domain class.
    The oofem::mesh object is an attribute of this class
    """

    def __init__(self, oofemlibDomain):
        self.__domain = oofemlibDomain

    def giveNumberOfVertices(self):
        return self.__domain.giveNumberOfDofManagers()

    def giveNumberOfCells(self):
        return self.__domain.giveNumberOfElements()

    def giveVertex(self, i):
        _dman = self.__domain.giveDofManager(i+1)
        if (_dman.hasCoordinates()):
            ans = vertex.Vertex(i, _dman.giveLabel(), (_dman.giveCoordinate(1), _dman.giveCoordinate(2), _dman.giveCoordinate(3)))
            return ans

    def giveCell(self, i):
        _elem = self.__domain.giveElement(i+1)
        _gtype=_elem.giveGeometryType()
        if (_gtype == oofemlib.Element_Geometry_Type.EGT_quad_1):
            return cell.Quad_2d_lin(self, i, _elem.giveLabel(), 
                                    (_elem.giveDofManagerNumber(1)-1, 
                                     _elem.giveDofManagerNumber(2)-1,
                                     _elem.giveDofManagerNumber(3)-1,
                                     _elem.giveDofManagerNumber(4)-1))
        elif (_gtype == oofemlib.Element_Geometry_Type.EGT_triangle_1):
            return cell.Triangle_2d_lin(self, i, _elem.giveLabel(), 
                                    (_elem.giveDofManagerNumber(1)-1, 
                                     _elem.giveDofManagerNumber(2)-1,
                                     _elem.giveDofManagerNumber(3)-1))
        elif (_gtype == oofemlib.Element_Geometry_Type.EGT_tetra_1):
            return cell.Tetrahedron_3d_lin(self, i, _elem.giveLabel(), 
                                    (_elem.giveDofManagerNumber(1)-1, 
                                     _elem.giveDofManagerNumber(2)-1,
                                     _elem.giveDofManagerNumber(3)-1,
                                     _elem.giveDofManagerNumber(4)-1))
        else:
            raise TypeError("Unsupported EGT Type encountered")
        
    def locateCell(self, position):
        """Locates cell containing given point"""
        localizer = self.__domain.giveSpatialLocalizer()
        print localizer
        print "class name: ",localizer.giveClassName()
        _pos = oofemlib.FloatArray(3)
        _pos[0]=position[0]
        _pos[1]=position[1]
        _pos[2]=position[2]
        _pos.printYourself()
        _regionList=oofemlib.IntArray(1)
        _regionList[0]=1
        cell = localizer.giveElementContainingPoint(_pos, _regionList)
        print cell
        cellNum = cell.giveNumber()
        return self.giveCell(cellNum)

class OOFEM_API(api.API):
    """
    This class implements oofem API.
    """
    def __init__(self, inputfile):
        dr=oofemlib.OOFEMTXTDataReader(inputfile);
        self.problem=oofemlib.InstanciateProblem(dr,oofemlib.problemMode._processor,0);
        self.problem.checkProblemConsistency();

    def giveField(self, fieldID, tstep):
        d = self.problem.giveDomain(1)
        mymesh = OofemUnstructuredMesh(d)
        f = field.Field(mymesh, field.FieldID.FID_Displacement, field.FieldType.vertex_based, field.FieldValueType.vector)
        #assume 2d problem
        mask=oofemlib.IntArray(2)
        mask[0]=oofemlib.DofIDItem.D_u
        mask[1]=oofemlib.DofIDItem.D_v
        print mask
        #set field 
        dl=oofemlib.FloatArray(2)
        dg=oofemlib.FloatArray(2)
        t=oofemlib.FloatMatrix(2,2)
        oofem_domain = self.problem.giveDomain(1)
        for vertex in mymesh.vertices():
            print vertex.number
            dman=oofem_domain.giveDofManager(vertex.number+1)
            dman.giveUnknownVector(dl, mask, oofemlib.EquationID.EID_MomentumBalance, oofemlib.ValueModeType.VM_Total, self.problem.giveCurrentStep())
            dman.computeDofTransformation(t, mask, oofemlib.DofManTransfType._toGlobalCS)
            dg.beProductOf(t,dl);
            val=(dg[0], dg[1], 0.0)
            f.setValue(vertex.number, val)
        # ok return created field, but how to retun an error code?
        return f 
      
    def updateField(self, field, tstep):
        return

    def registerField(self, field, tstep):    
        return

    def solve(self, tstep):
        self.problem.solveYourself()
        
    def giveCriticalTimeStep(self):
        return
