class FieldType:
    """
    Represent the supported values of FieldType. 
    """
    vertex_based = 1
    cell_based   = 2

class FieldValueType:
    """
    Represent the supported values of Field value types. 
    """
    scalar = 1
    vector = 2
    tensor = 3

class FieldID:
    """ 
    Datermines the physical meaning of field values
    """
    FID_Displacement = 1
    FID_Temperature = 2
    FID_Humidity = 3

class Field:
    """
    Representation of field. Field is generraly a mapping, that assigns 
    a value to points in space.
    The field values stored in self.__values list. The index is either vertex or cell id.
    In case of cell-based fields, the value may be list (or tuple) containing values of individual IPs.
    """
    
    def __init__(self, mesh, field_id, field_type, value_type):
        self.__mesh = mesh
        self.__field_id = field_id
        self.__field_type = field_type
        self.__value_type = value_type
        if (self.__field_type == FieldType.vertex_based):
            self.__values = [None]*mesh.giveNumberOfVertices()
        else:
            self.__values = [None]*mesh.giveNumberOfCells()

    def giveMesh(self):
        return self.__mesh

    def evaluate(self, position):
        cell = self.__mesh.locateCell(position)
        if (self.__field_type == FieldType.vertex_based):
            answer = cell.interpolate(position, vertexValues)
        else:
            answer = cell.interpolateIP(position, IPValues)
        return answer
        
    def evaluateAtVertex (self, vertexID):
        if (self.__field_type == FieldType.vertex_based):
            return self.giveValue(vertexID)

    def giveValue(self, componentID):
        """
        Returns the value associated to given component (vertex or cell IP).
        The component is a tuple: (vertexID,) or (CellID, IPID)
        """
        return self.__values[componentID]

    def setValue(self, componentID, value):
        """
        Sets the value associated to given component (vertex or cell IP).
        The componentID is a tuple: (vertexID,) or (CellID, IPID)
        
        ToDo:
        If mesh has mapping attached (it is a mesh view) then we have to remember value locally and record change.
        The source field values are updated after commit() method is invoked.
        """
        self.__values[componentID] = value

    def commit(self):
        """
        Commits the recorded changes (via setValue method) to primary field.
        """

        

        
