#enum to distinguish iterartors provided by domain
VERTICES=0; CELLS=1

class MeshIterator:
    """
    Class representing iterator on Mesh components (vertices, cells).
    """
    def __init__(self, mesh, type):
        if ((type == VERTICES) or (type == CELLS)):
            self.type = type
            self.mesh = mesh
        else:
            print "Unsupported iterator type"
            abort(0)

    def __iter__(self):
        self.i = 0
        return self

    def next(self):
        if self.type == VERTICES:
            if self.i+1 <= self.mesh.giveNumberOfVertices():
                item = self.mesh.giveVertex(self.i)
                self.i += 1
                return item
            else:
                raise StopIteration()

        elif self.type == CELLS:
            if self.i+1 <= self.mesh.giveNumberOfCells():
                item = self.mesh.giveCell(self.i)
                self.i += 1
                return item
            else:
                 raise StopIteration()
               


class Mesh:
    """
    Abstract representation of a computaional domain.
    Described using computational cells and vertices, determining the cell geometry.
    Derived classes represent structured, unstructred FE grids, FV grids, etc.
    """
    def __init__(self):
        self.__mapping = None

    def giveNumberOfVertices(self):
        """Returns the number of Vertices."""
        return 0;

    def giveNumberOfCells(self):
        """Returns the number of Cells."""
        return 0;
        

    def giveVertex(self, i):
        """Returns i-th vertex."""

    def giveCell(self, i):
        """Returns i-th cell."""
        
    def giveMapping(self):
        """Returns the mapping associated to mesh."""
        return self.__mapping

    def locateCell(self, position):
        """Locates cell containing given point"""
        

    # some basic iterators
    def vertices(self):
        return MeshIterator(self, VERTICES) 

    def cells(self):
        return MeshIterator(self, CELLS)


class UnstructuredMesh(Mesh):
    """
    Represents unstructured mesh. Maintains the list of vertices and cells.
    """

    def __init__(self):
        self.__vertices = []
        self.__cells    = []

    def giveVertex(self, i):
        return self.__vertices[i]

    def giveCell(self, i):
        return self.__cells[i]


    
