#!/usr/bin/env python

from api.oofem.oofem_interface import *

from enthought.mayavi.scripts import mayavi2
from enthought.tvtk.api import tvtk
from enthought.mayavi.core.engine import Engine
from enthought.pyface.api import GUI

from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util

from enthought.mayavi.sources.vtk_data_source import VTKDataSource
from enthought.mayavi.modules.outline import Outline
from enthought.mayavi.modules.surface import Surface
from enthought.mayavi.modules.vectors import Vectors


def main():
    global mayavi

    #dr=oofemlib.OOFEMTXTDataReader("/home/bp/work/patch100.in");
    ##dr=oofemlib.OOFEMTXTDataReader("/home/bp/work/bdam7.oofem.in");
    ##dr=oofemlib.OOFEMTXTDataReader("/home/bp/work/patch300.in");

    tstep = timestep.TimeStep(1.0, 1.0)
    try:
        oofem = OOFEM_API("3pbt.in")
        oofem.solve(tstep)
        f = oofem.giveField(field.FieldID.FID_Displacement, tstep)
    except APIError as e:
        print "OOFEM_API error occurred:",e
        
    src = util.field2VTKDataSource(f)

    mayavi.add_source(src)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
                   
if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()
