from mupif import mesh

"""
It is important for the meshView to be able to represent a subset of master domain of a lower dimension,
eg. a surface in 3d mesh. As the cells in meshView do not have direct master cell in master mesh,
the meshView should be capable to maintain its own cells. 
On the other hand, if the surface is not directly represented in the master mesh (like an arbitrary cut),
the new mesh (and corresponding fields) are assumed to be created by some transfer operator,
creating a new mesh, as the direct mapping to master mesh does not exist.
"""

class MeshView(Mesh):
    """
    Mesh view represents a subset of master mesh, defined by mapping context.
    """
    def __init__(self, mappingContext, masterMesh):
        self.__mapping     = mappingContext
        self.__masterMesh  = masterMesh
        
    def giveVertex(self, i):
        """Returns i-th vertex."""
        return self.__masterMesh.giveVertex(self.__mapping.giveMasterVertexNumber(i))

    def giveCell(self, i):
        """Returns i-th cell."""
        return self.__masterMesh.giveCell(self.__mapping.giveMasterCellNumber(i))
        
    def locateCell(self, position):
        """Locates cell containing given point"""
        masterCell = self.__masterMesh.locateCell(position)
        # now check if master cell is a part of local subset

        return masterCell


