from mupif import field
from mupif import mesh
from mupif import cell
from mupif import timestep
from numpy import array, arange, random, zeros
from enthought.tvtk.api import tvtk
from enthought.mayavi.sources.vtk_data_source import VTKDataSource

def create_tvtk_ug(mesh):
    """generate tvtk.UnstructuredGrid grid with different cell types.
    Returns a created unstructured grid
    """
    points=[]
    for vertex in mesh.vertices():
        points.append(vertex.coords)
    cells=[]
    cellTypes=[]
    offsets=[]
    for _cell in mesh.cells():
        print "huu "
        offsets.append(len(cells))
        cells.append(len(_cell.vertices))
        cells.extend(_cell.vertices)
        if (_cell.giveGeometryType() == cell.Quad_2d_1):
            cellTypes.append(tvtk.Quad().cell_type)
        elif (_cell.giveGeometryType() == cell.Triangle_2d_1):
            cellTypes.append(tvtk.Triangle().cell_type)
        elif (_cell.giveGeometryType() == cell.Tetrahedron_3d_1):
            cellTypes.append(tvtk.Tetra().cell_type)
        else:
            raise TypeError("Unsupported cell type")
    # Create the array of cells unambiguously.
    cell_array = tvtk.CellArray()
    cell_array.set_cells(len(offsets), cells)

    # Now create the UG.
    ans = tvtk.UnstructuredGrid(points=points)
    # Now just set the cell types and reuse the ug locations and cells.
    ans.set_cells(cellTypes, offsets, cell_array)

    return ans

def attachPrimaryField(ug, field):
    #t1=range(0,100,8)
    #temperature=array(t1)
    mesh=field.giveMesh()
    a=zeros((mesh.giveNumberOfVertices(),3))
    for vertex in mesh.vertices():
        (a[vertex.number,0],a[vertex.number,1],a[vertex.number,2]) = field.evaluateAtVertex(vertex.number)

    #ug.point_data.vectors=a
    #ug.point_data.vectors.name = 'displacements'

    ug.point_data.vectors=a
    ug.point_data.vectors.name = 'velocities'
    
    return

def field2VTKDataSource (field):
    _ug = create_tvtk_ug(field.giveMesh())
    attachPrimaryField(_ug,field)
    return VTKDataSource(data = _ug)
   
 
