import Pyro4

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif.api.api import *
from mupif import bbox
from mupif import viewcontext
from mupif import field
from mupif import meshview
from mupif import timestep
from mupif import util
from mupif import agent

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors
from mayavi.filters.transform_data import TransformData

api=Pyro4.Proxy("PYRONAME:Mupif.example07.agent")
tstep=timestep.TimeStep(1.,1.)

#create first request bbox
bb1=bbox.BBox((0,0,0),(3,4,1))
uri=api.giveFieldUri(1,tstep)
remoteField=Pyro4.core.Proxy(uri)
print remoteField.evaluate((2.2,1,0))

#obtain local field view of remote data, with unlinked master field
# to prevent its serialization
lfv1=api.giveBBoxFieldView(bb1, 1, tstep, unlinkMaster=True)
lfv1.master=remoteField #set reference to remote master
lfv1.update() #update from remote master values

bb2=bbox.BBox((3,0,0),(6,4,1))
lfv2=api.giveBBoxFieldView(bb2, 1, tstep, unlinkMaster=True)
lfv2.master=remoteField #set reference to remote master
lfv2.update() #update from remote master values

print "lfv2:", lfv2.mesh.giveNumberOfVertices(), lfv2.mesh.giveNumberOfCells(), lfv2.values

lfv3=api.giveBBoxFieldView(bb1, 1, tstep, unlinkMaster=True)
lfv3.master=remoteField #set reference to remote master
lfv3.update() #update from remote master values
lfv3.merge(lfv2) #merge with lfv2

print "lfv3:", lfv3.mesh.giveNumberOfVertices(), lfv3.mesh.giveNumberOfCells(), lfv3.values

src0 = util.field2VTKDataSource(api.giveField(1,1))
src1 = util.field2VTKDataSource(lfv1)
src2 = util.field2VTKDataSource(lfv2)
src3 = util.field2VTKDataSource(lfv3)
    

mayavi = Engine()
mayavi.new_scene()

mayavi.add_source(src0)
mayavi.add_module(Outline())
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.data_range=[0, 20]
m.module_manager.scalar_lut_manager.show_scalar_bar = True

mayavi.add_source(src1)
mayavi.add_module(Outline())
t= TransformData()
#t.widget.SetEnabled(0)
t.transform.translate (0,0,1) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
mayavi.add_filter(t)
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.data_range=[0, 20]

if 1:
    mayavi.add_source(src2)
    mayavi.add_module(Outline())
    t= TransformData()
#t.widget.SetEnabled(0)
    t.transform.translate (0,0,2) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
    mayavi.add_filter(t)
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
    m.module_manager.scalar_lut_manager.data_range=[0, 20]


if 1:
    mayavi.add_source(src3)
    mayavi.add_module(Outline())
    t= TransformData()
    #t.widget.SetEnabled(0)
    t.transform.translate (0,0,3) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
    mayavi.add_filter(t)
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
    m.module_manager.scalar_lut_manager.data_range=[0, 20]

gui = GUI()
gui.start_event_loop()
#print lfv.evaluate((2.2,1,0))
