import Pyro4
import time

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif.api.api import *
from mupif import bbox
from mupif import viewcontext
from mupif import field
from mupif import meshview
from mupif import timestep
from mupif import util
from mupif import agent

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors
from mayavi.filters.transform_data import TransformData


print "Initializing ....",
t0=time.clock()
api=Pyro4.Proxy("PYRONAME:Mupif.example08.agent")
tstep=timestep.TimeStep(1.,1.)
mayavi = Engine()
scene=mayavi.new_scene()
#create request bbox
bb=bbox.BBox((1,0,0),(2,2,1))
remoteField1=Pyro4.core.Proxy(api.giveFieldUri(1,tstep))
remoteField2=Pyro4.core.Proxy(api.giveFieldUri(2,tstep))
print "done in ", time.clock() - t0, "[s]"


t0=time.clock()
print "Buiding VTK data source of remote field ....",
src0 = util.field2VTKDataSource(api.giveField(1,1))
mayavi.add_source(src0)
mayavi.add_module(Outline())
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.data_range=[-1, 1]
m.module_manager.scalar_lut_manager.show_scalar_bar = True
print "done in ", time.clock() - t0, "[s]"


t0=time.clock()
print "Buiding VTK data source of remote field ....",
src00 = util.field2VTKDataSource(api.giveField(2,1))
mayavi.add_source(src00)
mayavi.add_module(Outline())
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.data_range=[-1, 1]
print "done in ", time.clock() - t0, "[s]"


#obtain local field view of remote data (field1), with unlinked master field
# to prevent its serialization
t0=time.clock()
print "Querring BBoxFieldView ....",
lfv1=api.giveBBoxFieldView(bb, 1, tstep, unlinkMaster=True)
print "done in ", time.clock() - t0, "[s]"
lfv1.master=remoteField1 #set reference to remote master
t0=time.clock()
print "Updating data from remote master ....",
lfv1.update() #update from remote master values
print "done in ", time.clock() - t0, "[s]"

src1 = util.field2VTKDataSource(lfv1)
mayavi.add_source(src1)
mayavi.add_module(Outline())
t= TransformData()
#t.widget.SetEnabled(0)
t.transform.translate (0,0,1) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
mayavi.add_filter(t)
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.data_range=[-1, 1]

if 1:
    #obtain local field view of remote data (field2), with unlinked master field
    # to prevent its serialization
    lfv2=api.giveBBoxFieldView(bb, 2, tstep, unlinkMaster=True)
    lfv2.master=remoteField2 #set reference to remote master
    lfv2.update() #update from remote master values

    src2 = util.field2VTKDataSource(lfv2)
    mayavi.add_source(src2)
    mayavi.add_module(Outline())
    t= TransformData()
    t.widget.enabled=0
    t.transform.translate (0,0,2) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
    mayavi.add_filter(t)
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
    m.module_manager.scalar_lut_manager.data_range=[-1, 1]


if 1:
#create merged view 
    lfv3=api.giveBBoxFieldView(bb, 1, tstep, unlinkMaster=True)
    lfv3.master=remoteField1 #set reference to remote master
    lfv3.update() #update from remote master values
    lfv3.merge(lfv2) #merge with lfv2

    #print "lfv3:", lfv3.mesh.giveNumberOfVertices(), lfv3.mesh.giveNumberOfCells(), lfv3.values

    src3 = util.field2VTKDataSource(lfv3)
    mayavi.add_source(src3)
    mayavi.add_module(Outline())
    t= TransformData()
    #t.widget.SetEnabled(0)
    t.transform.translate (0,0,3) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
    mayavi.add_filter(t)
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
    m.module_manager.scalar_lut_manager.data_range=[-1, 1]

gui = GUI()
gui.start_event_loop()
#print lfv.evaluate((2.2,1,0))
