#
#               MuPIF: Multi-Physics Integration Framework 
#                   Copyright (C) 2010 Borek Patzak
#
#       Czech Technical University, Faculty of Civil Engineering,
#       Department of Mechanics, 166 29 Prague, Czech Republic
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

class API:
    """
    An abstract class representing an Application Interface (API).
    It defines the required functionality provided by individual applications.
    """
    def giveMesh (self, tstep):
        """
        Returns the computational mesh for given solution step.
        """

    def giveField(self, fieldID, tstep):
        """
        Returns the requested field at given time. Field is identified by fieldID.
        Returns an error code if not succesfull.
        """
    
    def updateField(self, field, tstep):
        """
        Updates the provided field values to given time.
        Returns an error code if not succesfull.
        """
    def registerField(self, field, tstep):
        """
        Registers the given (remote) field in application. 
        """

    def solve(self, tstep):
        """
        Proceeds the solution from actual state to given time.
        Returns an error code.
        """

    def giveCriticalTimeStep(self):
        """
        Returns the actual (related to current state) critical time step.
        """
    def giveAssemblyTime(self, tstep):
        """
        Returns the assembly time related to given time step.
        The registered fields (inputs) should in general correspond to this time.
        """
    def isConverged(self, tstep):
        """
        Returns True if convergence reached for given solution step.
        """

        
class APIError(Exception):
    def __init__(self, _msg):
        self.msg = _msg
    def __str__(self):
         return repr(self.msg)
