#!/usr/bin/env python

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors

from mupif.api.oofem import oofem_interface 
from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import transferoperator
from mupif import octree
from mupif import cell

import time as _time
import oofemlib

def main():
    global mayavi

    time = 0.0;
    nsteps = 10;
    dt=20000.0;
    try:
        oofem_heat = oofem_interface.OOFEM_API("test03.tm.in")
        oofem_structural = oofem_interface.OOFEM_API("test03.sm.in")

        for i in range(nsteps):

            #dt = min (oofem_heat.giveCriticalTimeStep(), oofem_structural.giveCriticalTimeStep())
            tstep = timestep.TimeStep(time, dt)

            # solve heat transfer problem
            oofem_heat.solve(tstep)
            tf_source = oofem_heat.giveField(field.FieldID.FID_Temperature, tstep)
            # create empty target field on target domain
            targetDomain = oofem_structural.giveMesh(tstep)
            targetField = field.Field(targetDomain, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar)
            # increase in element tolerance
            cell.tolerance=0.11
            # octree.debug = 1
            # map fields
            start = _time.clock()
            transferoperator.CellInterpolationTO().map(tf_source, targetField)
            elapsed = (_time.clock() - start)
            print "Mapping took ", elapsed, "[seconds]"

            # register temperature field for structural analysis
            oofem_structural.registerField(targetField, tstep)
            # run structural analysis
            oofem_structural.solve(tstep)
        
    except api.api.APIError as e:
        print "OOFEM_API error occurred:",e

    # obtain displacement field at last step
    df = oofem_structural.giveField(field.FieldID.FID_Displacement, tstep)
    src1 = util.field2VTKDataSource(df)

    # use vtk pipeline to visualize displacements
    mayavi.add_source(src1)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
                   
if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()
