import Pyro4

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif.api.api import *
from mupif import bbox
from mupif import viewcontext
from mupif import field
from mupif import meshview
from mupif import timestep
from mupif import util
from mupif import agent

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors
from mayavi.filters.transform_data import TransformData

api=Pyro4.Proxy("PYRONAME:Mupif.example06.agent")
tstep=timestep.TimeStep(1.,1.)
bb=bbox.BBox((0,0,0),(10,10,1))
#request local copy of remote mesh (local copy)
mesh = api.giveMesh(1,tstep)
vc=viewcontext.BBoxViewContext(bb, mesh)
mv=meshview.MeshView(vc, mesh)
#local field view created refering to local master mesh copy 
fv=field.FieldView(mv, api.giveField(1,1)) 
print fv.evaluate((2.2,1,0))

#communicate with remote field
uri=api.giveFieldUri(1,tstep)
remoteField=Pyro4.core.Proxy(uri)
print remoteField.evaluate((2.2,1,0))

#obtain local field view of remote data, with unlinked master field
# to prevent its serialization
lfv=api.giveBBoxFieldView(bb, 1, tstep, unlinkMaster=True)
lfv.master=remoteField #set reference to remote master
lfv.update() #update from remote master values
print lfv
print lfv.evaluate((2.7,1,0))

src0 = util.field2VTKDataSource(api.giveField(1,1))
src1 = util.field2VTKDataSource(lfv)
mayavi = Engine()
mayavi.new_scene()

mayavi.add_source(src0)
mayavi.add_module(Outline())
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.data_range=[0, 20]

mayavi.add_source(src1)
mayavi.add_module(Outline())
t= TransformData()
#t.widget.SetEnabled(0)
t.transform.translate (0,0,1) #set_matrix([0, 0, 0,0.,    0, 2,0,0,     0,0,0.0,0.0,    0, 0, 0, 1])
mayavi.add_filter(t)
m = Surface()
m.actor.property.representation='w'
mayavi.add_module(m)
m.module_manager.scalar_lut_manager.show_scalar_bar = True
m.module_manager.scalar_lut_manager.data_range=[0, 20]
gui = GUI()
gui.start_event_loop()
#print lfv.evaluate((2.2,1,0))
