#
#               MuPIF: Multi-Physics Integration Framework 
#                   Copyright (C) 2011 Borek Patzak
#
#       Czech Technical University, Faculty of Civil Engineering,
#       Department of Mechanics, 166 29 Prague, Czech Republic
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import field

class TransferOperator:
    """
    Abstract class representing transfer operator to map source field to target field. 
    Source and target fields can have different meshed associated.
    Parameter options contains a dictionary of optional named parameters.
    """
    def map (self, source, target, **options): 
        """Maps source field to target one"""


class CellInterpolationTO(TransferOperator):
    "Uses source cell interpolation  to determine target data at vertices"""
    def map (self,source, target, **options):
        #interpolate data for target vertices
        for tv in target.giveMesh().vertices():
            try:
                target.setValue(tv.number, source.evaluate(tv.coords))
            except ValueError as e:
                print "CellInterpolationTO failed for node ", tv.number
                field.debug = 1
                source.evaluate(tv.coords)
                raise ValueError

